﻿using log4net;
using Microsoft.AspNetCore.Mvc;
using Moq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Controllers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using Xunit;

namespace VA.PPMS.IWS.Api.Unit.Test
{
    public class PpmsDataStreamControllerTests
    {
        [Fact]
        public void PpmsDataStreamTestReturns200()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.GetAsync(It.IsAny<string>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.OK)));

            var controller = new PpmsDataStreamController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };

            // Act
            var results = controller.Get(string.Empty);
            var statusCodeResult = results.GetAwaiter().GetResult() as StatusCodeResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(200, statusCodeResult.StatusCode);
        }

        [Fact]
        public void PpmsDataStreamTestReturns412()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.GetAsync(It.IsAny<string>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.PreconditionFailed)));

            var controller = new PpmsDataStreamController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };

            // Act
            var results = controller.Get(string.Empty);
            var statusCodeResult = results.GetAwaiter().GetResult() as StatusCodeResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(412, statusCodeResult.StatusCode);
        }

        [Fact]
        public void PpmsDataStreamTestReturns424()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.GetAsync(It.IsAny<string>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.ExpectationFailed)));

            var controller = new PpmsDataStreamController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };

            // Act
            var results = controller.Get(string.Empty);
            var statusCodeResult = results.GetAwaiter().GetResult() as StatusCodeResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(424, statusCodeResult.StatusCode);
        }
    }
}